// Name Input Processing
Game_Interpreter.prototype.command303 = function() {
    if (!$gameParty.inBattle()) {
        if ($dataActors[this._params[0]]) {
			if (ConfigManager.touchbuttons) {
				$gameScreen.showPicture(456, "zBtnBack", 0, 0, 0, 100, 100, 255, 0);
			}
			else {
				$gameScreen.erasePicture(456);
			}
			
            SceneManager.push(Scene_Name);
            SceneManager.prepareNextScene(this._params[0], this._params[1]);
        }
    }
    return true;
};

Scene_Name.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
	$gameSwitches.setValue(133, true) //not number input
	if (this._actorId == 20) {
		$gameActors.actor(20).setName($gameActors.actor(19)._name)
	}
    this._actor = $gameActors.actor(this._actorId);
    this.createEditWindow();
    this.createInputWindow();
};

Scene_Name.prototype.createInputWindow = function() {
    this._inputWindow = new Window_NameInput(this._editWindow);
    this._inputWindow.setHandler('ok', this.onInputOk.bind(this));
    this._inputWindow.setHandler('cancel', this.onInputCancel.bind(this));
    this.addWindow(this._inputWindow);
};

Scene_Name.prototype.onInputOk = function() {
    this._actor.setName(this._editWindow.name());
	
	if (this._actor._actorId == 20) {
		$gameSwitches.setValue(157, true)
		$gameSwitches.setValue(158, false)
		$gameActors.actor(19).setName($gameActors.actor(20)._name)
	}
	
    this.popScene();
	
};

Scene_Name.prototype.onInputCancel = function() {
//    this._actor.setName(this._editWindow.name());
	$gameSwitches.setValue(158, false)
	$gameSwitches.setValue(157, false)
    this.popScene();
	
	if (ConfigManager.touchbuttons) {
		$gameScreen.showPicture(456, "zBtnMenu", 0, 0, 0, 100, 100, 255, 0);
	}
	else {
		$gameScreen.erasePicture(456);
	}
};



Window_NameEdit.prototype.windowHeight = function() {
    return this.fittingHeight(1);
};


Window_NameEdit.prototype.itemRect = function(index) {
	if (this._maxLength >= 20) {
		return {
			x: (index * this.charWidth()) - ((this._maxLength / 2) * this.charWidth()) + 222,
			y: 0,
			width: this.charWidth(),
			height: this.lineHeight()
		}
	}
	else {
		return {
			x: (index * this.charWidth()) - ((this._maxLength / 2) * this.charWidth()) + 102,		
			y: 0,
			width: this.charWidth(),
			height: this.lineHeight()
		}
	}
};

Window_NameEdit.prototype.refresh = function() {
    this.contents.clear();
/*		this.contents.fontSize = 25
		if (Utils.isMobileDevice()) {this.contents.fontSize = 23}
*/		
    for (var i = 0; i < this._maxLength; i++) {
        this.drawUnderline(i);
    }
    for (var j = 0; j < this._name.length; j++) {
        this.drawChar(j);
    }
    var rect = this.itemRect(this._index);
    this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
};

Window_NameEdit.prototype.drawUnderline = function(index) {
    var rect = this.underlineRect(index);
    var color = this.underlineColor();
    this.contents.paintOpacity = 125;
    this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, color);
    this.contents.paintOpacity = 255;
};

//Chara Name
Window_NameEdit.prototype.initialize = function(actor, maxLength) {
    var width = 219
    var height = this.windowHeight();
    var x = 528-78
    var y = 26
	
	if (maxLength == 16) {
		maxLength = 37
		width = 459
		x = 410-78
	}
	
		
    Window_Base.prototype.initialize.call(this, x, y, width, height);
    this._actor = actor;
//    this._name = actor.name().slice(0, this._maxLength);
	if (actor.name() != "") {		this._name = actor.name().slice(0, maxLength);	}
	else {		this._name = ""	}
	
    this._index = this._name.length;
    this._maxLength = maxLength;
    this._defaultName = this._name;
    this.deactivate();
    this.refresh();
};


//Chara Name Input
Window_NameInput.prototype.initialize = function(editWindow) {
    var x = 132-78
    var y = 84

    var width = 1016
    var height = 557
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._editWindow = editWindow;
    this._page = 0;
    this._index = 0;
    this.refresh();
    this.updateCursor();
    this.activate();
};


Window_NameInput.prototype.itemRect = function(index) {
    return {
        x: (index % 10 * 50) * 2,
        y: (Math.floor(index / 10) * this.lineHeight()) * 2.5,
        width: 50 * 2,
        height: this.lineHeight() * 2.5
    };
};


Window_NameInput.LATIN1 =
        [ 'A','B','C','D','E',  'a','b','c','d','e',
          'F','G','H','I','J',  'f','g','h','i','j',
          'K','L','M','N','O',  'k','l','m','n','o',
          'P','Q','R','S','T',  'p','q','r','s','t',
          'U','V','W','X','Y',  'u','v','w','x','y',
          'Z',' ',' ',' ',' ',  'z','Clr','PgDn','Del','OK'];
Window_NameInput.LATIN2 =
        [ '0','1','2','3','4',  '~','_','-','+','=',
          '5','6','7','8','9',  '[',']','{','}','|',
          '!','@','#','$','%',  ':',';','"',',','.',
          '^','&','*','(',')',  '<','>','/','?',' ',
          ' ',' ',' ',' ',' ',  ' ',' ',' ',' ',' ',
          ' ',' ',' ',' ',' ',  ' ','Clr','PgUp','Del','OK'];


Window_NameInput.prototype.maxItems = function() {
    return 60;
};

Window_NameInput.prototype.character = function() {
    return this._index < 56 ? this.table()[this._page][this._index] : '';
};

Window_NameInput.prototype.isPageChange = function() {
    return this._index === 57;
};

Window_NameInput.prototype.isOk = function() {
    return this._index === 59;
};

Window_NameInput.prototype.isDel = function() {
    return this._index === 58;
};

Window_NameInput.prototype.isClr = function() {
    return this._index === 56;
};


Window_NameInput.prototype.processOk = function() {
    if (this.character()) {
        this.onNameAdd();
    } else if (this.isPageChange()) {
        SoundManager.playOk();
        this.cursorPagedown();
    } else if (this.isDel()) {
        this.processBack();
    } else if (this.isClr()) {
        this.processClr();
    } else if (this.isOk()) {
        this.onNameOk();
    }
};

Window_NameInput.prototype.onNameOk = function() {
    if (this._editWindow.name() === '') {
        if (this._editWindow.restoreDefault()) {
            SoundManager.playOk();
        } else {
			this.callOkHandler();
//            SoundManager.playBuzzer();
        }
    } else {
        SoundManager.playOk();
        this.callOkHandler();
    }
};

Window_NameInput.prototype.processClr = function() {
    if (this._editWindow.clr()) {
        SoundManager.playCancel();
    }
	else {
		SoundManager.playBuzzer();
	}
};


Window_NameEdit.prototype.clr = function() {
    if (this._index > 0) {
        this._index = 0;
        this._name = ""
        this.refresh();
        return true;
    } else {
        return false;
    }
};

Window_NameInput.prototype.refresh = function() {
    var table = this.table();
    this.contents.clear();
    this.resetTextColor();
    for (var i = 0; i < 60; i++) {
        var rect = this.itemRect(i);
        rect.x += 3;
        rect.width -= 6;
        this.drawText(table[this._page][i], rect.x, rect.y + 27, rect.width, 'center');
    }
};

Window_NameInput.prototype.cursorDown = function(wrap) {
    if (this._index < 50 || wrap) {
        this._index = (this._index + 10) % 60;
    }
};

Window_NameInput.prototype.cursorUp = function(wrap) {
    if (this._index >= 10 || wrap) {
        this._index = (this._index + 50) % 60;
    }
};

Window_NameInput.prototype.processJump = function() {
    if (this._index !== 59) {
        this._index = 59;
        SoundManager.playCursor();
    }
};



Window_NameInput.prototype.processBack = function() {
    if (this._editWindow.back()) {
		SoundManager.playCancel();
    }
	else {
		if (Input.isPressed('cancel')) {
			SoundManager.playCancel();
			this.callHandler('cancel');
		}
		else {
			SoundManager.playBuzzer();
		}
	}
};
